#!/usr/bin/env bash

# build_pkg.sh: creates linux distribution packages for sandstorm-agent.
# Uploading to aptly is performed in clean-deploy via a job specified by
# deploy.json and set in jenkings.groovy

set -e

BIN_NAME="sandstorm-agent"
PACKAGE_NAME="sandstorm-agent"
ARTIFACT_DIR="${1}"
BUILD="production staging"

# PACKAGE_VER is inject into manta from the jenkings.groovy job
if [ -z $PACKAGE_VER ]; then
    echo "PACKAGE_VER environment variable not set, bailing"
    exit 1
fi

if [ -z $ARTIFACT_DIR ]; then
    echo "ARTIFACT_DIR environment variable not set, bailing"
    exit 1
fi

# TODO: move these functions out to jenkins jobs (that already exist).
function build_monit_package {
  # $1 = distro, $2 = PACKAGE_NAME, $3 = path, $4 = after_install_file, $5 = monit_conf
  mkdir -p "${ARTIFACT_DIR}/${3}"
  fpm -s dir --deb-no-default-config-files \
      -t ${1} \
      -a amd64 \
      -n ${2} \
      -d monit \
      -v $PACKAGE_VER \
      -p "${ARTIFACT_DIR}/${3}/${2}-monit.${1}" \
      --after-install ${4} \
      --after-upgrade ${4} \
      --config-files ${5} \
      -C $PACKAGE_ROOT
}

function build_systemd_package {
  mkdir -p "${ARTIFACT_DIR}/${3}"
  fpm -s dir --deb-no-default-config-files \
      -t ${1} \
      -a amd64 \
      -n ${2} \
      -d monit \
      -v $PACKAGE_VER \
      -p "${ARTIFACT_DIR}/${3}/${2}-systemd.${1}" \
      --after-install ${4} \
      --after-upgrade ${4} \
      --config-files ${5} \
      -C $PACKAGE_ROOT
}

for environment in $BUILD; do
  echo "Sourcing build script for environment: ${environment}"
  DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
  source $DIR/$environment/build-$environment.sh
done

echo "Artifacts built in ${ARTIFACT_DIR}:"
ls -l ${ARTIFACT_DIR}/*/*/*.{deb,rpm}
