# Builds a staging package for sandstorm-agent. This allows testing without
# inhibiting the production & canary build pipeline.

# Use +e because this is staging.
set +e

# A place to build the package root folder.
PACKAGE_ROOT=$(mktemp -d -t package_XXXX)

# Find the path to this script.
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

mkdir -p "${PACKAGE_ROOT}/usr/bin/"
# copy the binary into the pkg
cp -a ${ARTIFACT_DIR}/${BIN_NAME} "${PACKAGE_ROOT}/usr/bin/${PACKAGE_NAME}"

echo "Creating Monit Debian sandstorm-agent packages. (Precise & Trusty)"
mkdir -p "${PACKAGE_ROOT}/etc/monit/conf.d"
MONIT_CONF="/etc/monit/conf.d/${PACKAGE_NAME}"
AFTER_INSTALL="${DIR}/after-install.monit"
cp -a "${DIR}/monit_conf.standalone" "${PACKAGE_ROOT}/${MONIT_CONF}"
# We build both a production, and canary version for the binary. We do this because
# apt uses the metadata associated with a dpkg rather than the file name itself for
# indexing it's packages. As such, simply copying or renaming a production dpkg
# to canary won't work.
if [ "$environment" = "production" ]; then
  build_monit_package deb ${PACKAGE_NAME} ${environment}/monit ${AFTER_INSTALL} ${MONIT_CONF}
  build_monit_package deb ${PACKAGE_NAME}-canary canary/monit ${AFTER_INSTALL} ${MONIT_CONF}
else
  # For non-production the only difference here is the package name.
  build_monit_package deb ${PACKAGE_NAME}-${environment} ${environment}/monit ${AFTER_INSTALL} ${MONIT_CONF}
fi


echo "Creating Monit+Systemd Debian sandstorm-agent packages. (Xenial & Zesty)"
mkdir -p "${PACKAGE_ROOT}/etc/systemd/system"
AFTER_INSTALL="${DIR}/after-install.debian"
cp -a "${DIR}/sandstorm-agent.service.debian" "${PACKAGE_ROOT}/etc/systemd/system/sandstorm-agent.service"
cp -a "${DIR}/monit_conf.systemd" "${PACKAGE_ROOT}/${MONIT_CONF}"
cp -a "${DIR}/sandstorm-monit-agent.sh" "${PACKAGE_ROOT}/usr/bin/sandstorm-monit-agent"
chmod 0755 "${PACKAGE_ROOT}/usr/bin/sandstorm-monit-agent"
if [ "$environment" = "production" ]; then
  build_systemd_package deb ${PACKAGE_NAME} ${environment}/systemd ${AFTER_INSTALL} ${MONIT_CONF}
  build_systemd_package deb ${PACKAGE_NAME}-canary canary/systemd ${AFTER_INSTALL} ${MONIT_CONF}
else
  build_systemd_package deb ${PACKAGE_NAME}-${environment} ${environment}/systemd ${AFTER_INSTALL} ${MONIT_CONF}
fi

echo "Creating Monit RedHat sandstorm-agent packages. (All versions)"
rm -rf "${PACKAGE_ROOT}/etc/systemd" "${PACKAGE_ROOT}/etc/monit" "${PACKAGE_ROOT}/usr/bin/sandstorm-monit-agent"
mkdir -p "${PACKAGE_ROOT}/etc/monit.d"
MONIT_CONF="/etc/monit.d/${PACKAGE_NAME}"
AFTER_INSTALL="${DIR}/after-install.redhat"
cp -a "${DIR}/monit_conf.standalone" "${PACKAGE_ROOT}/${MONIT_CONF}"
if [ "$environment" = "production" ]; then
  build_monit_package rpm ${PACKAGE_NAME} ${environment}/redhat ${AFTER_INSTALL} ${MONIT_CONF}
  build_monit_package rpm ${PACKAGE_NAME}-canary canary/redhat ${AFTER_INSTALL} ${MONIT_CONF}
else
  build_monit_package rpm ${PACKAGE_NAME}-${environment} ${environment}/redhat ${AFTER_INSTALL} ${MONIT_CONF}
fi

# Not ready for this yet.
#echo "Creating Systemd RedHat sandstorm-agent packages. (RedHat 8+)"
#AFTER_INSTALL="${DIR}/after-install.redhat"
#cp -a "${DIR}/sandstorm-agent.service.redhat" "${PACKAGE_ROOT}/etc/systemd/system/sandstorm-agent.service"
#build_systemd_package rpm ${PACKAGE_NAME} ${environment}/redhat ${AFTER_INSTALL}
#test -z $prod || build_systemd_package rpm ${PACKAGE_NAME}-canary canary/redhat ${AFTER_INSTALL}
