#!/usr/bin/env bash

set -e

#Test
mkdir output && touch gotest.out && touch coverage.out
go vet ./...
errcheck -blank ./...
test -z $(golint $(go list ./...| grep -v /mocks$) | tee /dev/stderr)
go list -f '{{ join .Deps "\n" }}' ./cmd/sandstorm-apiserver/... | grep -v 'vendor/' | grep 'code.justin.tv/systems'| xargs -n1 -I{} sh -c '2>&1 go test -v -coverprofile=coverage.tmp_$(echo {} | rev | cut -d/ -f1 | rev) {}  | tee -a gotest.out'
ls coverage.tmp_* | head -n1 | xargs cat | head -n1 > coverage.out
ls -x coverage.tmp_* | xargs -I{} sh -c 'gocovmerge {} | grep -v mode >> coverage.out'
go2xunit -fail -input gotest.out -output gotest.xml
twerk get-tests gotest.xml
go tool cover -html=coverage.out -o coverage.html
mv test_report.xml coverage.html coverage.out  output/
