#!/usr/bin/env bash

# build_pkg.sh: creates linux distribution packages for sandstorm.
# Uploading to aptly is performed in clean-deploy via a job specified by
# deploy.json and set in jenkings.groovy

set -e

LATEST_TAG=$(cat cmd/sandstorm-cli/version)

PACKAGE_VERSION="$(date +%Y%m%d%H%M%S)-${LATEST_TAG}"

if [ -z "$PACKAGE_VERSION" ]; then
    echo "PACKAGE_VERSION environment variable not set, bailing"
    exit 1
fi

if [ -z "$SUPPORTED_DISTS" ]; then
    SUPPORTED_DISTS='precise xenial'
fi

BIN_NAME="sandstorm"
PACKAGE_NAME="sandstorm"
ARCH="amd64"
PACKAGE_ROOT=$(mktemp -d -t package_XXXX)
ARTIFACT_DIR="${1}"
OUTPUT_DIR="${2}"
SUPPORTED_PACKAGE_FORMATS="deb"
PACKAGES="sandstorm"
# prepare artifact folder
mkdir -p "${ARTIFACT_DIR}"

mkdir -p "${PACKAGE_ROOT}/usr/bin/"
# copy our binary into the pkg
cp -a ${ARTIFACT_DIR}/${BIN_NAME} "${PACKAGE_ROOT}/usr/bin/${PACKAGE_NAME}"

echo "Building dpkgs"

for format in $SUPPORTED_PACKAGE_FORMATS; do
    for pkgname in $PACKAGES; do
        for dist in $SUPPORTED_DISTS; do
            mkdir -p "${OUTPUT_DIR}/${dist}"
            fpm -s dir -t ${format} -a "${ARCH}" -n "${pkgname}" -v "${PACKAGE_VERSION}-${dist}" -p "${OUTPUT_DIR}/${dist}/${pkgname}.${format}" -C $PACKAGE_ROOT
        done
    done
done

echo "Artifacts built in: ${ARTIFACT_DIR}"
