package consumedsecrets

import (
	"fmt"

	"code.justin.tv/systems/sandstorm/inventory/heartbeat"

	"github.com/asaskevich/govalidator"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

//ConsumedSecret represents a secret consumed by a agent
type ConsumedSecret struct {
	heartbeat.DynamoHeartbeat
}

func unmarshalConsumedSecret(item map[string]*dynamodb.AttributeValue) (consumer *ConsumedSecret, err error) {
	s := new(heartbeat.DynamoHeartbeat)

	err = dynamodbattribute.UnmarshalMap(item, &s)
	if err != nil {
		return
	}

	_, err = govalidator.ValidateStruct(s)
	if err != nil {
		err = fmt.Errorf("error validating secret from dynamodb: %s", err.Error())
		return
	}

	consumer = &ConsumedSecret{
		DynamoHeartbeat: *s,
	}
	return
}
