resource "aws_dynamodb_table" "heartbeats" {
  name           = "heartbeats${var.env_suffix}"
  read_capacity  = 10
  write_capacity = "${var.heartbeats_write_capacity}"
  hash_key       = "composite_key"

  attribute {
    name = "composite_key"
    type = "S"
  }

  attribute {
    name = "host"
    type = "S"
  }

  attribute {
    name = "service"
    type = "S"
  }

  attribute {
    name = "secret"
    type = "S"
  }

  attribute {
    name = "heartbeat_received"
    type = "N"
  }

  ttl {
    attribute_name = "expires_at"
    enabled        = true
  }

  global_secondary_index {
    name            = "HostIndex"
    hash_key        = "host"
    range_key       = "heartbeat_received"
    write_capacity  = "${var.heartbeats_write_capacity}"
    read_capacity   = 10
    projection_type = "ALL"
  }

  global_secondary_index {
    name            = "ServiceIndex"
    hash_key        = "service"
    range_key       = "heartbeat_received"
    write_capacity  = "${var.heartbeats_write_capacity}"
    read_capacity   = 10
    projection_type = "ALL"
  }

  global_secondary_index {
    name            = "SecretIndex"
    hash_key        = "secret"
    range_key       = "heartbeat_received"
    write_capacity  = "${var.heartbeats_write_capacity}"
    read_capacity   = 10
    projection_type = "ALL"
  }

  tags {
    Name        = "heartbeats"
    Environment = "${var.env}"
  }
}
