provider "aws" {
  region              = "${var.region}"
  profile             = "${var.aws_profile}"
  allowed_account_ids = ["${var.account_id}"]
}

output "inventory-gateway-api" {
  value = "${aws_api_gateway_deployment.inventory.invoke_url}"
}

output "inventory-gateway-api-lambda-execution-arn" {
  value = "${aws_api_gateway_deployment.inventory.execution_arn}"
}

output "inventory-gateway-api-id" {
  value = "${aws_api_gateway_deployment.inventory.id}"
}
