#!/bin/sh
set -e
ENVIRONMENT="$1"
[ -z "$ENVIRONMENT" ] && \
  echo "usage: sh jenkins/deploy-inventory-lambda.sh ENVIRONMENT" && \
  exit 1

docker run --rm \
  -e AWS_ACCESS_KEY_ID \
  -e AWS_SECRET_ACCESS_KEY \
  -v $(pwd):/target \
  -w /target/inventory \
  docker-registry.internal.justin.tv/devtools/python2.7.6 \
  sh -c "
  pip install boto3 && \
  python ./scripts/admin.py deploy $ENVIRONMENT
"
