package policy

import (
	"fmt"
	"testing"

	"github.com/satori/go.uuid"
	. "github.com/smartystreets/goconvey/convey"
)

func TestExtractPolicySecretKeys(t *testing.T) {
	pg := new(IAMPolicyGenerator)
	pg.SetPathPrefixEnvironment("testing")
	Convey("ExtractPolicySecretKeys should return secret keys", t, func() {
		keys := []string{
			"syseng/service/production/key",
			"video/service/production/key",
		}
		namespaces := []string{
			"syseng",
			"video",
		}
		document := pg.PolicyDocument(keys, namespaces, false, "arn doesn't matter")
		extractedKeys := ExtractPolicySecretKeys(document)

		So(len(extractedKeys), ShouldEqual, len(keys))
		for _, v := range extractedKeys {
			So(keys, ShouldContain, v)
		}
	})
	Convey("generating RoleArn should match expectations", t, func() {
		someRoleName := uuid.NewV4().String()
		generatedRoleARN := pg.GenerateRoleARN(someRoleName)
		expectedRoleARN := fmt.Sprintf("arn:aws:iam::734326455073:role/sandstorm/testing/templated/role/%s", someRoleName)

		So(generatedRoleARN, ShouldEqual, expectedRoleARN)
	})
}
