resource "aws_elb" "elb" {
  name            = "sandstorm-${var.env}"
  subnets         = ["${values(var.subnet_ids)}"]
  security_groups = ["${var.vpc_security_group}"]
  internal        = true

  listener {
    instance_port      = 8080
    instance_protocol  = "http"
    lb_port            = 443
    lb_protocol        = "https"
    ssl_certificate_id = "${var.acm_certificate_arn}"
  }

  health_check {
    healthy_threshold   = 2
    unhealthy_threshold = 2
    timeout             = 3
    target              = "HTTP:8080/status"
    interval            = 30
  }

  instances                 = ["${aws_instance.sandstorm-apiserver.*.id}"]
  cross_zone_load_balancing = true

  tags {
    Name  = "sandstorm"
    Owner = "Systems Security Engineering sse@twitch.tv"
  }
}

resource "aws_elb" "elb-compat" {
  name            = "sandstorm-compat-${var.env}"
  subnets         = ["${values(var.subnet_ids)}"]
  security_groups = ["${var.vpc_security_group}"]
  internal        = true

  listener {
    instance_port      = 8080
    instance_protocol  = "http"
    lb_port            = 443
    lb_protocol        = "https"
    ssl_certificate_id = "${var.compat_acm_certificate_arn}"
  }

  health_check {
    healthy_threshold   = 2
    unhealthy_threshold = 2
    timeout             = 3
    target              = "HTTP:8080/status"
    interval            = 30
  }

  instances                 = ["${aws_instance.sandstorm-apiserver.*.id}"]
  cross_zone_load_balancing = true
}

output "elb_compat_dns_name" {
  value = "${aws_elb.elb-compat.dns_name}"
}

output "elb_name" {
  value = "${aws_elb.elb.name}"
}
