resource "aws_route53_record" "apiserver-dns-record" {
  provider = "aws.twitch-aws"
  zone_id  = "${var.twitch_aws_r53_zone_id}"
  count    = "${var.instance_count}"
  name     = "sandstorm-${var.env}-${replace(element(aws_instance.sandstorm-apiserver.*.id, count.index), "i-", "")}.${var.hostname_env}.us-west2.justin.tv"
  type     = "A"
  ttl      = "300"
  records  = ["${element(aws_instance.sandstorm-apiserver.*.private_ip, count.index)}"]
}

resource "aws_route53_record" "elb-dns-record" {
  provider = "aws.twitch-aws"
  zone_id  = "${var.twitch_aws_r53_zone_id}"
  name     = "sandstorm-${var.env}.${var.hostname_env}.us-west2.justin.tv"
  type     = "CNAME"
  ttl      = "300"
  records  = ["${aws_elb.elb.dns_name}"]
}
