module "staging" {
  source             = "./modules"
  env                = "staging"
  instance_count     = "1"
  aws_profile        = "twitch-sse-dev"
  admin_role_arn     = "arn:aws:iam::505345203727:role/Admin"
  s2s_roles_wildcard = "arn:aws:iam::180116294062:role/malachai/*"

  subnet_ids = {
    us-west-2a = "subnet-37ecae7e"
    us-west-2b = "subnet-6b341e0c"
    us-west-2c = "subnet-a44f9bff"
  }

  vpc_security_group         = "sg-59e0cd22"
  hostname_env               = "dev"
  acm_certificate_arn        = "arn:aws:acm:us-west-2:505345203727:certificate/9ccf856a-c1f7-4495-944b-0b2cc9317b98"
  compat_acm_certificate_arn = "arn:aws:acm:us-west-2:505345203727:certificate/59e29a22-e2a6-486f-ab59-2d60e2e9230b"
}
