provider "aws" {
  region  = "us-west-2"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

resource "aws_iam_policy" "aux" {
  name = "sandstorm-agent-${var.env}-aux"
  path = "/sandstorm/${var.env}/aux_policy/"

  policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
      {
          "Action": [
              "sqs:CreateQueue",
              "sqs:GetQueueAttributes",
              "sqs:DeleteMessage",
              "sqs:ReceiveMessage",
              "sqs:SetQueueAttributes"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_sqs_arn}"
          ]
      },
      {
          "Action": [
              "sns:Subscribe"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_sns_arn}"
          ]
      },
      {
          "Action": [
              "kms:Decrypt"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_kms_arn}"
          ]
      },
      {
          "Action": [
              "iam:GetUser"
          ],
          "Effect": "Allow",
          "Resource": [
              "arn:aws:iam::734326455073:user/$${aws:username}"
          ]
      },
      {
          "Sid": "DynamoDbDenyCrossEnvAccess",
          "Effect": "Deny",
          "Action": [
              "dynamodb:UpdateItem",
              "dynamodb:PutItem"
          ],
          "Resource": "${var.secrets_table_arn}",
          "Condition": {
              "ForAllValues:StringEquals": {
                  "dynamodb:Attributes": "cross_env"
              }
          }
      },
      {
        "Sid": "AssumeInventoryRole",
        "Effect": "Allow",
        "Action": [
          "sts:AssumeRole"
        ],
        "Resource": "${var.inventory_execute_api_role_arn}"
      }
  ]
}
POLICY
}

resource "aws_iam_policy" "rw-aux" {
  name = "sandstorm-agent-${var.env}-rw-aux"
  path = "/sandstorm/${var.env}/aux_policy/"

  policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
      {
          "Action": [
              "kms:Decrypt",
              "kms:GenerateDataKey"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_kms_arn}"
          ]
      },
      {
          "Action": [
              "sqs:CreateQueue",
              "sqs:GetQueueAttributes",
              "sqs:DeleteMessage",
              "sqs:ReceiveMessage",
              "sqs:SetQueueAttributes"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_sqs_arn}"
          ]
      },
      {
          "Action": [
              "sns:Subscribe"
          ],
          "Effect": "Allow",
          "Resource": [
              "${var.secrets_sns_arn}"
          ]
      },
      {
          "Action": [
              "iam:GetUser"
          ],
          "Effect": "Allow",
          "Resource": [
              "arn:aws:iam::${var.aws_account_id}:user/$${aws:username}"
          ]
      },
      {
          "Sid": "DynamoDbDenyCrossEnvAccess",
          "Effect": "Deny",
          "Action": [
              "dynamodb:UpdateItem",
              "dynamodb:PutItem"
          ],
          "Resource": "${var.secrets_table_arn}",
          "Condition": {
              "ForAllValues:StringEquals": {
                  "dynamodb:Attributes": "cross_env"
              }
          }
      },
      {
        "Sid": "AssumeInventoryRole",
        "Effect": "Allow",
        "Action": [
          "sts:AssumeRole"
        ],
        "Resource": "${var.inventory_execute_api_role_arn}"
      }
  ]
}
POLICY
}
