variable "sandstorm_apiserver_role_arn" {}
variable "sandstorm_agent_role_arn" {}

variable "sandstorm_python_testing_role_arn" {
  description = "role arn used in sandstorm-python integration tests"
}

variable "inventory_admin_testing_role_arn" {}
variable "inventory_stormwatch_testing_role_arn" {}
variable "s2s_role_arn" {}

variable "inventory_deployment_role_arn" {
  description = "this role gives access to deploying the imventory lambda"
}

variable "aws_profile" {}
variable "aws_account_id" {}

variable "aws_region" {
  default = "us-west-2"
}

provider "aws" {
  region  = "${var.aws_region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

resource "aws_iam_user" "dev" {
  name = "sandstorm-dev"
  path = "/"
}

resource "aws_iam_user_policy" "dev_assume_sandstorm_role" {
  name = "sandstorm_assume_role"
  user = "${aws_iam_user.dev.name}"

  policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "sts:AssumeRole"
      ],
      "Effect": "Allow",
      "Resource": [
        "${var.sandstorm_apiserver_role_arn}",
        "${var.sandstorm_agent_role_arn}",
        "${var.inventory_admin_testing_role_arn}",
        "${var.inventory_stormwatch_testing_role_arn}",
        "${var.s2s_role_arn}",
        "${var.inventory_deployment_role_arn}",
        "${var.sandstorm_python_testing_role_arn}"
      ]
    }
  ]
}
POLICY
}
