resource "aws_route53_record" "sandstorm-agent-canary-dns-record" {
  provider = "aws.twitch-aws"
  zone_id  = "${var.twitch_aws_r53_zone_id}"
  count    = "${var.instance_count}"
  name     = "sandstorm-agent-canary-${replace(element(aws_instance.sandstorm-agent-canary.*.id, count.index), "i-", "")}.${var.hostname_env}.us-west2.justin.tv"
  type     = "A"
  ttl      = "300"
  records  = ["${element(aws_instance.sandstorm-agent-canary.*.private_ip, count.index)}"]
}
