package faststats

import (
	"time"

	"github.com/cep21/circuit/v3/faststats"
)

// generated by goforward github.com/cep21/circuit/v3/faststats github.com/cep21/circuit/faststats

// AtomicBoolean is a helper struct to simulate atomic operations on a boolean
type AtomicBoolean = faststats.AtomicBoolean

// AtomicInt64 is a helper struct to simulate atomic operations on an int64
// Note that I could have used `type AtomicInt642 int64`, but I did not want to make it easy
// to do + and - operations so easily without using atomic functions.
type AtomicInt64 = faststats.AtomicInt64

// RollingBuckets simulates a time rolling list of buckets of items.  It is safe to use JSON to encode this object
// in a thread safe way.
//
// This implementation cheats in order to not take a lock.  It is correct, but only if the total size of the buckets (NumBuckets * BucketWidth)
// is less than any duration of how long Advance will take to execute.  In anything but super small bucket sizes this should
// be fine.  The common case, where (NumBuckets * BucketWidth >= 1sec) should always work.
type RollingBuckets = faststats.RollingBuckets

// RollingCounter uses a slice of buckets to keep track of counts of an event over time with a sliding window
type RollingCounter = faststats.RollingCounter

// NewRollingCounter initializes a rolling counter with a bucket width and # of buckets
func NewRollingCounter(bucketWidth time.Duration, numBuckets int, now time.Time) RollingCounter {
	return faststats.NewRollingCounter(bucketWidth, numBuckets, now)
}

// RollingPercentile is a bucketed array of time.Duration that cycles over time
type RollingPercentile = faststats.RollingPercentile

// SortedDurations is a sorted list of time.Duration that allows fast Percentile operations
type SortedDurations = faststats.SortedDurations

// NewRollingPercentile creates a new rolling percentile bucketer
func NewRollingPercentile(bucketWidth time.Duration, numBuckets int, bucketSize int, now time.Time) RollingPercentile {
	return faststats.NewRollingPercentile(bucketWidth, numBuckets, bucketSize, now)
}

// TimedCheck lets X events happen every sleepDuration units of time.  For optimizations, it uses TimeAfterFunc to reset
// an internal atomic boolean for when events are allowed.  This timer could run a little bit behind real time since
// it depends on when the OS decides to trigger the timer.
type TimedCheck = faststats.TimedCheck
