package responsetimeslo

import (
	"github.com/cep21/circuit/v3/metrics/responsetimeslo"
)

// generated by goforward github.com/cep21/circuit/v3/metrics/responsetimeslo github.com/cep21/circuit/metrics/responsetimeslo

// Tracker sets up a response time SLO that has a reasonable meaning for hystrix.  Use it for an SLO like
// "99% of requests should respond correctly within 300 ms".
//
// Define a maximum time that a healthy request is allowed to take.  This should be less than the maximum "break" point
// of the circuit.  Only Successful requests <= that time are counted as healthy.
//
// Requests that are interrupted, or have bad input, are not considered healthy or unhealthy.  It's like they don't
// happen.  All other types of errors are blamed on the down stream service, or the Run method's request time.  They
// will count as failing the SLA.
type Tracker = responsetimeslo.Tracker

// Config controls how SLO is tracked by default for a Tracker
type Config = responsetimeslo.Config

// Factory creates SLO monitors for a circuit
type Factory = responsetimeslo.Factory

// Collector can collect metrics about the happy SLO of a request.
type Collector = responsetimeslo.Collector
