package rolling

import (
	"github.com/cep21/circuit/v3"
	"github.com/cep21/circuit/v3/metrics/rolling"
)

// generated by goforward github.com/cep21/circuit/v3/metrics/rolling github.com/cep21/circuit/metrics/rolling

// StatFactory helps the process of making stat collectors for circuit breakers
type StatFactory = rolling.StatFactory

// FindCommandMetrics searches a circuit for the previously stored run stats.  Returns nil if never set.
func FindCommandMetrics(c *circuit.Circuit) *RunStats {
	return rolling.FindCommandMetrics(c)
}

// FindFallbackMetrics searches a circuit for the previously stored fallback stats.  Returns nil if never set.
func FindFallbackMetrics(c *circuit.Circuit) *FallbackStats {
	return rolling.FindFallbackMetrics(c)
}

// RunStats tracks rolling windows of callback counts
type RunStats = rolling.RunStats

// RunStatsConfig configures a RunStats
type RunStatsConfig = rolling.RunStatsConfig

// FallbackStats tracks fallback metrics in rolling buckets
type FallbackStats = rolling.FallbackStats

// FallbackStatsConfig configures how to track fallback stats
type FallbackStatsConfig = rolling.FallbackStatsConfig
