// +build integration

package fanout

import (
	"fmt"
	"testing"

	"net/http"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/feeds-common/entity"
	"code.justin.tv/feeds/feeds-common/verb"
	"code.justin.tv/feeds/graphdb/proto/graphdb"
	"code.justin.tv/feeds/service-common"
	"github.com/cactus/go-statsd-client/statsd"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestCandidateFollowsIntegration(t *testing.T) {
	Convey("With a feeds aws destination", t, func() {
		graphdbClient := graphdb.NewGraphDBProtobufClient("http://graphdb-staging.internal.justin.tv", http.DefaultClient)

		dconf := distconf.Distconf{}
		conf := FollowsDiscoveryConfig{}
		So(conf.Load(&dconf), ShouldBeNil)
		fd := FollowsDiscovery{
			Stats: &service_common.StatSender{
				SubStatter: &statsd.NoopClient{},
			},
			GraphDB: graphdbClient,
			Config:  &conf,
		}

		Convey("we should be able to send a post", func(c C) {
			activity := &Activity{
				Entity: entity.New("post", "1"),
				Verb:   verb.Create,
				//Actor: "23161357", // Lirik
				Actor: entity.New("user", "27222385"), // cep21 (jack)
			}
			ctx := context.Background()
			candidates, err := fd.Candidates(ctx, activity)
			So(err, ShouldBeNil)
			So(len(candidates), ShouldBeGreaterThan, 1)
			fmt.Println(len(candidates))
			t.Log(len(candidates))
		})
	})
}
