// +build integration

package fanout_test

import (
	"testing"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout/fantest"
	"code.justin.tv/feeds/feeds-common/entity"
	"code.justin.tv/feeds/feeds-common/verb"
	"code.justin.tv/feeds/service-common"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestFriendsDiscoveryIntegration(t *testing.T) {
	Convey("should get a user's friends", t, func() {
		ctx := context.Background()

		mockStory := &fanout.Activity{
			Actor:  entity.New(entity.NamespaceUser, "123"),
			Verb:   verb.Create,
			Entity: entity.New(entity.NamespacePost, "1"),
		}
		mockFriends := []string{"456", "789"}
		friendsMap := make(fantest.FriendsMap, len(mockFriends))
		for _, id := range mockFriends {
			friendsMap[id] = true
		}
		mockFriendsDiscovery := &fanout.FriendsDiscovery{
			Friendship: &fantest.MemoryFriendshipClient{FriendsMap: map[string]fantest.FriendsMap{
				mockStory.Actor.ID(): friendsMap,
			}},
			Stats:  service_common.NopStatSender(),
			Config: &fanout.FriendsDiscoveryConfig{},
		}
		mockFriendsDiscovery.Config.Load(&distconf.Distconf{})

		friends, err := mockFriendsDiscovery.Candidates(ctx, mockStory)
		So(err, ShouldBeNil)
		So(friends, ShouldHaveLength, len(mockFriends))
	})
}
