package fanout

import "golang.org/x/net/context"

// ChannelFeed adds activity that is only for the channel feed into the actor's channel feed location
type ChannelFeed struct {
}

var _ ConsumerCandidateDiscovery = &ChannelFeed{}

// Candidates returns the actor itself if Verb is a post for channel feed
func (d *ChannelFeed) Candidates(ctx context.Context, in *Activity) ([]FeedWithMetadata, error) {
	return []FeedWithMetadata{
		{
			Feed: "c:" + in.Actor.ID(),
		},
	}, nil
}
