package fanout

import (
	"math/rand"
	"strconv"
	"testing"
	"time"

	"code.justin.tv/feeds/feeds-common/entity"
	. "github.com/smartystreets/goconvey/convey"
)

func TestActivityBatch(t *testing.T) {
	Convey("With a single feed ID batch", t, func() {
		ab := ActivityBatch{
			Activities: makeActivity(10),
			FeedIDs:    makeFeedIDS(1),
		}
		Convey("Size of 10 should split once", func() {
			a, b := ab.split(10)
			So(b, ShouldBeNil)
			So(a.FeedIDs, ShouldResemble, ab.FeedIDs)
			So(a.Activities, ShouldResemble, ab.Activities)
		})
		Convey("Size of 9 should split twice", func() {
			a, b := ab.split(9)
			So(a.FeedIDs, ShouldResemble, ab.FeedIDs)
			So(a.Activities, ShouldResemble, ab.Activities[0:9])

			c, d := b.split(9)
			So(d, ShouldBeNil)
			So(c.FeedIDs, ShouldResemble, b.FeedIDs)
			So(c.Activities, ShouldResemble, b.Activities)
		})
	})
	Convey("With a single activity batch", t, func() {
		ab := ActivityBatch{
			Activities: makeActivity(1),
			FeedIDs:    makeFeedIDS(10),
		}
		Convey("Size of 10 should split once", func() {
			a, b := ab.split(10)
			So(b, ShouldBeNil)
			So(a.FeedIDs, ShouldResemble, ab.FeedIDs)
			So(a.Activities, ShouldResemble, ab.Activities)
		})
		Convey("Size of 9 should split twice", func() {
			a, b := ab.split(9)
			So(a.FeedIDs, ShouldResemble, ab.FeedIDs[0:9])
			So(a.Activities, ShouldResemble, ab.Activities)

			c, d := b.split(9)
			So(d, ShouldBeNil)
			So(c.FeedIDs, ShouldResemble, b.FeedIDs)
			So(c.Activities, ShouldResemble, b.Activities)
		})
	})
	Convey("With a matrix", t, func() {
		ab := &ActivityBatch{
			Activities: makeActivity(10),
			FeedIDs:    makeFeedIDS(10),
		}
		Convey("Size of 100 should split once", func() {
			a, b := ab.split(100)
			So(b, ShouldBeNil)
			So(a.FeedIDs, ShouldResemble, ab.FeedIDs)
			So(a.Activities, ShouldResemble, ab.Activities)
		})
		Convey("Size of 9 should split multiple times", func() {
			sr := rand.New(rand.NewSource(time.Now().UnixNano()))
			ab := &ActivityBatch{
				Activities: makeActivity(sr.Intn(20) + 1),
				FeedIDs:    makeFeedIDS(sr.Intn(20) + 1),
			}
			t.Log("Size of feedIDs", len(ab.FeedIDs), "size of activities", len(ab.Activities))
			finalCount := len(ab.FeedIDs) * len(ab.Activities)
			scount := make(map[string]struct{}, finalCount)
			count := 0
			splitSize := sr.Intn(15) + 1
			for {
				a, b := ab.split(int64(splitSize))
				for _, fi := range a.FeedIDs {
					for _, ac := range a.Activities {
						s := fi.Feed + "*" + ac.Entity.Encode()
						So(scount, ShouldNotContainKey, s)
						scount[s] = struct{}{}
					}
				}
				if b == nil {
					break
				}
				ab = b
				count++
			}
			So(len(scount), ShouldEqual, finalCount)
		})
	})
}

func makeActivity(l int) []*Activity {
	ret := make([]*Activity, 0, l)
	for i := 0; i < l; i++ {
		ret = append(ret, &Activity{
			Entity: entity.New("user", strconv.Itoa(i)),
		})
	}
	return ret
}

func makeFeedIDS(l int) []FeedWithMetadata {
	ret := make([]FeedWithMetadata, 0, l)
	for i := 0; i < l; i++ {
		ret = append(ret, FeedWithMetadata{Feed: strconv.Itoa(i)})
	}
	return ret
}
