package fantest

import (
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"code.justin.tv/feeds/log"
	"golang.org/x/net/context"
)

// MemoryCandidateDiscovery allow setting edges from memory
type MemoryCandidateDiscovery struct {
	ActorMap     map[string][]fanout.FeedWithMetadata
	DefaultEdges []fanout.FeedWithMetadata
	Err          error
	Log          log.Logger
}

var _ fanout.ConsumerCandidateDiscovery = &MemoryCandidateDiscovery{}

// Candidates detects edges from m.ActorMap.  If there is no entry, will use DefaultEdges.
func (m *MemoryCandidateDiscovery) Candidates(ctx context.Context, in *fanout.Activity) ([]fanout.FeedWithMetadata, error) {
	m.Log.Log("Detecting edges")
	if m.Err != nil {
		return nil, m.Err
	}
	if ret, exists := m.ActorMap[in.Actor.ID()]; exists {
		return ret, nil
	}
	return m.DefaultEdges, nil
}
