package fantest

import (
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"golang.org/x/net/context"
)

// ChanDestination is a MessageDestination that puts messages on a channel
type ChanDestination chan *fanout.Activity

var _ fanout.ActivityDestination = ChanDestination(nil)

// AddActivity puts a message on the channel, waiting until context closes.
func (c ChanDestination) AddActivity(ctx context.Context, i *fanout.Activity) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	case c <- i:
		return nil
	}
}
