package fantest

import (
	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/chat/friendship/client"
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/web/cohesion/client/v2"
	"golang.org/x/net/context"
)

// FriendsMap is a a map of one user's friends
type FriendsMap map[string]bool

// MemoryFriendshipClient is a barebones in-memory implementation cohesion.Client
type MemoryFriendshipClient struct {
	FriendsMap map[string]FriendsMap
}

var _ fanout.FriendshipClient = &MemoryFriendshipClient{}

// GetFriends lists all friends of a user ID
func (c MemoryFriendshipClient) GetFriends(ctx context.Context, userID string, params friendship.GetFriendsParams, reqOpts *twitchclient.ReqOpts) (*responses.FriendListResponse, error) {
	friends := c.FriendsMap[userID]
	friendsRes := make([]*v2.AssocResponse, len(friends))
	i := 0
	for friend := range friends {
		friendsRes[i] = &v2.AssocResponse{
			Entity: v2.Entity{ID: friend},
		}
		i++
	}
	return &responses.FriendListResponse{Friends: friendsRes}, nil
}
