package fantest

import (
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"code.justin.tv/feeds/log"
	"golang.org/x/net/context"
)

// MemoryActivitySource streams messages from InputStream
type MemoryActivitySource struct {
	Err         error
	Dest        fanout.ActivityDestination
	InputStream chan *fanout.Activity
	Log         log.Logger
}

var _ fanout.ActivitySource = &MemoryActivitySource{}

// Close the InputStream channel
func (m *MemoryActivitySource) Close() error {
	close(m.InputStream)
	return nil
}

// Start reading messages from InputStream and sending them to Dest
func (m *MemoryActivitySource) Start() error {
	for inputMsg := range m.InputStream {
		ctx := context.Background()
		m.Log.Log("MemoryActivitySource Sending a new message!")
		if err := m.Dest.AddActivity(ctx, inputMsg); err != nil {
			return err
		}
		m.Log.Log("MemoryActivitySource message sent!")
	}
	return nil
}
