package fantest

import (
	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"golang.org/x/net/context"
)

// MemoryStoriesReceiver stores received messages into StoryChan
type MemoryStoriesReceiver struct {
	Err       error
	StoryChan chan *fanout.ActivityBatch
}

var _ fanout.FeedStoriesReceiver = &MemoryStoriesReceiver{}

func (m *MemoryStoriesReceiver) queue(ctx context.Context, stories *fanout.ActivityBatch) error {
	if m.Err != nil {
		return m.Err
	}
	select {
	case <-ctx.Done():
		return ctx.Err()
	case m.StoryChan <- stories:
		return nil
	}
}

// QueueLowPriorityFeedStories adds the message to StoryChan channel
func (m *MemoryStoriesReceiver) QueueLowPriorityFeedStories(ctx context.Context, stories *fanout.ActivityBatch) error {
	return m.queue(ctx, stories)
}

// QueueMidPriorityFeedStories adds the message to StoryChan channel
func (m *MemoryStoriesReceiver) QueueMidPriorityFeedStories(ctx context.Context, stories *fanout.ActivityBatch) error {
	return m.queue(ctx, stories)
}

// QueueHighPriorityFeedStories adds the message to StoryChan channel
func (m *MemoryStoriesReceiver) QueueHighPriorityFeedStories(ctx context.Context, stories *fanout.ActivityBatch) error {
	return m.queue(ctx, stories)
}
