// +build integration

package fanout_test

import (
	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
)

type IntegrationTest struct {
	JSONConfig   *distconf.JSONConfig
	ConfigCommon service_common.ConfigCommon
}

func (t *IntegrationTest) Setup() error {
	t.JSONConfig = &distconf.JSONConfig{}
	if err := t.JSONConfig.RefreshFile("../../../../config/integration.json"); err != nil {
		return err
	}

	t.ConfigCommon = service_common.ConfigCommon{
		Team:          "feeds",
		Service:       "fanout",
		CustomReaders: []distconf.Reader{t.JSONConfig},
		BaseDirectory: "../../../../",
	}
	if err := t.ConfigCommon.Setup(); err != nil {
		return err
	}
	return nil
}

var integrationTest = IntegrationTest{}
