package fanout

import (
	"encoding/json"
	"strings"
	"time"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common/feedsqs"
	"github.com/aws/aws-sdk-go/service/sqs"
	"golang.org/x/net/context"
)

// SqsSourceConfig configures SqsSourceConstructor
type SqsSourceConfig struct {
	feedsqs.SQSQueueProcessorConfig
}

// Load configuration information
func (c *SqsSourceConfig) Load(dconf *distconf.Distconf) error {
	return c.SQSQueueProcessorConfig.Verify(dconf, "fanout", time.Second*3, 64, time.Minute*15)
}

// SqsSource can receive messages from a SQS queue
type SqsSource struct {
	feedsqs.SQSQueueProcessor
	Destination ActivityDestination
}

// Setup sets ProcessMessage and calls sub Setup()
func (s *SqsSource) Setup() error {
	s.SQSQueueProcessor.ProcessMessage = s.processMessage
	return s.SQSQueueProcessor.Setup()
}

func (s *SqsSource) processMessage(ctx context.Context, m *sqs.Message) error {
	msg := &Activity{}
	err := json.NewDecoder(strings.NewReader(*m.Body)).Decode(msg)
	if err != nil {
		return err
	}
	s.Log.Debug("New valid message seen")
	return s.Destination.AddActivity(ctx, msg)
}
