// +build integration

package fanout_test

import (
	"fmt"
	"testing"

	"code.justin.tv/feeds/fanout/cmd/fanout/internal/fanout"
	"code.justin.tv/feeds/service-common"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/sqs"
	. "github.com/smartystreets/goconvey/convey"
)

const exampleSourceMessage = `{
  "entity": "11211",
  "verb": "post_comment",
  "actor": "27222385"
}`

func TestIntegrationSendMessageIntoQueue(t *testing.T) {
	Convey("With a feeds aws cred", t, func() {
		So(integrationTest.Setup(), ShouldBeNil)
		dconf := integrationTest.ConfigCommon.Config
		clientProvider, awsConf := service_common.CreateAWSSession(dconf)
		sourceConfig := &fanout.SqsSourceConfig{}
		So(sourceConfig.Load(dconf), ShouldBeNil)
		sqsClient := sqs.New(clientProvider, awsConf...)
		smi := &sqs.SendMessageInput{
			QueueUrl:    aws.String(sourceConfig.QueueURL.Get()),
			MessageBody: aws.String(exampleSourceMessage),
		}
		fmt.Println(sourceConfig.QueueURL.Get())
		fmt.Println(*awsConf[0].Region)
		_, err := sqsClient.SendMessage(smi)
		So(err, ShouldBeNil)
	})
}
