package fanout

import (
	"strings"
	"testing"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/feeds-common/entity"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

const exampleUpdateFollowMessage = `{
  "Type" : "Notification",
  "MessageId" : "73f33b0d-4b01-5480-9596-6a3d536280f8",
  "TopicArn" : "arn:aws:sns:us-west-2:914569885343:following-service_production_updatefollow_notifications",
  "Message" : "{\"from_id\":\"116256076\",\"target_id\":\"133038144\",\"event\":\"unfollow\",\"updated_at\":\"2017-03-01T00:30:27.927773484Z\"}",
  "Timestamp" : "2017-03-01T00:30:27.930Z",
  "SignatureVersion" : "1",
  "Signature" : "cv1Se9VVd4Wui+TsVn54gkRIQrlPenG+GuIiCX+VzXPNidgctfxYoPSQ2oeevOYExwmFgRKwkMS5uCtmAMbybBwOaiN5ojTZIVyaRMN6GQ2alxfLn27msFi8arYcpo+FCOU9/DQrEhFIp+u/2Wi0aHpwnEaOLiE6GJeG0V2qd5YPT2H+tEw8k8ErwDeFrsrWGOgmM48Vz05uj/CGpoI4rkKdnL7wjp1DD7oJBZ2ZKMCRvTxJv9ttL2eaDl+Cwsjsy+iFXQcmIXbe3QTSIMuWri5i+XrnY8fQUvAb0zXBZ9NdN+aSxb4OGOQPNiccBHhmt9KAI14ANL0hT0FNc/t3Hw==",
  "SigningCertURL" : "https://sns.us-west-2.amazonaws.com/SimpleNotificationService-b95095beb82e8f6a046b3aafc7f4149a.pem",
  "UnsubscribeURL" : "https://sns.us-west-2.amazonaws.com/?Action=Unsubscribe&SubscriptionArn=arn:aws:sns:us-west-2:914569885343:following-service_production_updatefollow_notifications:00c04c1f-86a0-4d0d-9897-1a855bce429f",
  "MessageAttributes" : {
    "event" : {"Type":"String","Value":"updatefollow"}
  }
}`

func TestParseUpdateFollowMessage(t *testing.T) {
	Convey("Messages should parse", t, func() {
		msg, err := parseUpdateFollowMessage(strings.NewReader(exampleUpdateFollowMessage))
		So(err, ShouldBeNil)
		So(msg.FromID, ShouldEqual, "116256076")
		So(msg.TargetID, ShouldEqual, "133038144")
		So(msg.Event, ShouldEqual, "unfollow")
	})
}

func TestUpdateFollowSqsSource(t *testing.T) {
	Convey("Messages should forward", t, func() {
		memoryDst := &memDst{}
		ctx := context.Background()
		conf := UpdateFollowSqsSourceConfig{}
		memDistconf := distconf.InMemory{}
		So(memDistconf.Write("update-follow.sqssource.queue_url", []byte("_ignore_")), ShouldBeNil)
		So(conf.Load(&distconf.Distconf{
			Readers: []distconf.Reader{
				&memDistconf,
			},
		}), ShouldBeNil)
		x := UpdateFollowSqsSource{
			Destination:        memoryDst,
			UpdateFollowConfig: &conf,
		}
		So(x.processUpdateFollowMessage(ctx, strings.NewReader(exampleUpdateFollowMessage)), ShouldBeNil)
		a := memoryDst.buf[0]
		So(a.Actor, ShouldResemble, entity.New(entity.NamespaceUser, "116256076"))
		So(a.Entity, ShouldResemble, entity.New("follow", "133038144"))
	})
}
