freeStyleJob('feeds-fanout') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'feeds/fanout', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell './jenkins.sh'
    conditionalSteps {
      condition {
        shell 'test $GIT_BRANCH = "origin/master" && ./vendor/code.justin.tv/twitch/ecs-deploy/helpers/is-new-deploy.sh feeds fanout $GIT_COMMIT'
      }
      runner('DontRun')
      steps {
        downstreamParameterized {
          trigger('feeds-fanout-pipeline') {
            parameters {
              predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
            }
          }
        }
      }
    }
  }
}
