locals {
  owner   = "jlindamo@twitch.tv"
  team    = "feeds"
  region  = "us-west-2"
  service = "fanout"

  account_ids = {
    canary = "914569885343"
  }

  profiles = {
    canary = "twitch-feed-aws"
  }

  min_counts = {
    canary = "0"
  }

  desired_counts = {
    canary = "0"
  }

  max_counts = {
    canary = "0"
  }

  auto_promotes = {
    canary = "false"
  }

  promote_froms = {
    canary = "staging"
  }

  shared_froms = {
    canary = "production"
  }

  promote_from  = "${lookup(local.promote_froms, terraform.workspace)}"
  auto_promote  = "${lookup(local.auto_promotes, terraform.workspace)}"
  min_count     = "${lookup(local.min_counts, terraform.workspace)}"
  max_count     = "${lookup(local.max_counts, terraform.workspace)}"
  desired_count = "${lookup(local.desired_counts, terraform.workspace)}"
  shared_from   = "${lookup(local.shared_froms, terraform.workspace)}"
  profile       = "${lookup(local.profiles, terraform.workspace)}"
}

provider "aws" {
  profile             = "${local.profile}"
  allowed_account_ids = ["${lookup(local.account_ids, terraform.workspace)}"]
  region              = "${local.region}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/fanout-shared-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

provider "consul" {
  address    = "consul.internal.justin.tv"
  datacenter = "us-west2"
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config {
    bucket  = "${local.profile}"
    key     = "tfstate/feed/terraform/accounts/${local.profile}"
    region  = "us-west-2"
    profile = "${local.profile}"
  }
}

data "terraform_remote_state" "account_core" {
  backend   = "s3"
  workspace = "${terraform.workspace}"

  config {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-account.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "region_core" {
  backend   = "s3"
  workspace = "${terraform.workspace}"

  config {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-region-${local.region}.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "shared_data" {
  backend   = "s3"
  workspace = "${local.shared_from}"

  config {
    bucket  = "twitch-feed-aws"
    key     = "feeds/fanout-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "permissions" {
  source                   = "../../modules/permissions"
  environment              = "${terraform.workspace}"
  iam_id                   = "${module.fanout.iam_id}"
  output_highpri_queue_arn = "${data.terraform_remote_state.shared_data.output_highpri_queue_arn}"
  friendship_requests_arn  = "${data.terraform_remote_state.shared_data.friendship_requests_arn}"
  output_lowpri_queue_arn  = "${data.terraform_remote_state.shared_data.output_lowpri_queue_arn}"
  update_follow_arn        = "${data.terraform_remote_state.shared_data.update_follow_arn}"
  input_queue_arn          = "${data.terraform_remote_state.shared_data.input_queue_arn}"
  output_queue_arn         = "${data.terraform_remote_state.shared_data.output_queue_arn}"
}

module "fanout" {
  source           = "../../modules/cluster"
  environment      = "${terraform.workspace}"
  target_group_arn = "${data.terraform_remote_state.shared_data.target_group_arn}"
  cluster_name     = "${data.terraform_remote_state.region_core.common_cluster_name}"

  min_size                  = "${local.min_count}"
  desired_count             = "${local.desired_count}"
  max_size                  = "${local.max_count}"
  service_iam_role          = "${data.terraform_remote_state.account_core.service_iam_role}"
  task_autoscale_iam_role   = "${data.terraform_remote_state.account_core.task_autoscale_iam_role}"
  profile                   = "${local.profile}"
  promote_from              = "${local.promote_from}"
  auto_promote              = "${local.auto_promote}"
  deploy_aws_role           = "${data.terraform_remote_state.account_core.build_role}"
  container_loggroup_region = "${data.terraform_remote_state.region_core.container_loggroup_region}"
  container_loggroup        = "${data.terraform_remote_state.region_core.container_loggroup}"
  aws_creds                 = "${data.terraform_remote_state.account_core.jenkins_build_secret}"
  testing_assume_role       = "${data.terraform_remote_state.account_core.build_user_arn}"
}
