locals {
  service = "fanout"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"
}

variable "environment" {}
variable "input_queue_arn" {}
variable "output_queue_arn" {}
variable "output_lowpri_queue_arn" {}
variable "output_highpri_queue_arn" {}
variable "friendship_requests_arn" {}
variable "update_follow_arn" {}
variable iam_id {}

resource "aws_iam_policy" "sandstorm_assume_role" {
  name = "sandstorm_policy_${local.service}_${var.environment}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "sandstorm_attach_policy" {
  role       = "${var.iam_id}"
  policy_arn = "${aws_iam_policy.sandstorm_assume_role.arn}"
}

resource "aws_iam_policy" "sqs_policy" {
  name = "sqs_policy_${local.service}_${var.environment}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "Stmt1471373292000",
            "Effect": "Allow",
            "Action": [
                "sqs:DeleteMessage",
                "sqs:ReceiveMessage"
            ],
            "Resource": [
                "${var.input_queue_arn}"
            ]
        },
        {
            "Sid": "Stmt1471373361000",
            "Effect": "Allow",
            "Action": [
                "sqs:SendMessage"
            ],
            "Resource": [
                "${var.output_queue_arn}"
            ]
        },
        {
            "Sid": "Stmt1471373372000",
            "Effect": "Allow",
            "Action": [
                "sqs:SendMessage"
            ],
            "Resource": [
                "${var.output_lowpri_queue_arn}"
            ]
        },
        {
            "Sid": "Stmt1471373372005",
            "Effect": "Allow",
            "Action": [
                "sqs:SendMessage"
            ],
            "Resource": [
                "${var.output_highpri_queue_arn}"
            ]
        },
        {
            "Sid": "Stmt1471373372001",
            "Effect": "Allow",
            "Action": [
                "sqs:ReceiveMessage",
                "sqs:DeleteMessage"
            ],
            "Resource": [
                "${var.friendship_requests_arn}"
            ]
        },
        {
            "Sid": "Stmt1471373372002",
            "Effect": "Allow",
            "Action": [
                "sqs:ReceiveMessage",
                "sqs:DeleteMessage"
            ],
            "Resource": [
                "${var.update_follow_arn}"
            ]
        }
    ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "sqs_attach_policy" {
  role       = "${var.iam_id}"
  policy_arn = "${aws_iam_policy.sqs_policy.arn}"
}
