package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) addFriendV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	requiredParams, err := gojiplus.FetchRequiredURLParams(ctx, "user_id", "friend_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	requesterID := requiredParams["user_id"]
	targetID := requiredParams["friend_id"]

	// The "is_recommended" query parameter indicates whether this friend request comes from
	// the recommended friends flow. If so, save the flag as metadata on the relationship.
	q := r.URL.Query()
	isRecommended := q.Get("is_recommended") == "true"

	if requesterID == targetID {
		err := errx.New("a user cannot friend themself")
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusConflict)
		return
	}

	if err := s.backend.AddFriend(ctx, requesterID, targetID, isRecommended); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
