package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/friendship/client"
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) bulkAddFriendsV1(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	requiredParams, err := gojiplus.FetchRequiredURLParams(ctx, "user_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	userID := requiredParams["user_id"]

	params, err := parseBulkAddFriendsV1Request(r)
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}

	if err := s.backend.BulkAddFriends(ctx, userID, params.TargetIDs); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}

func parseBulkAddFriendsV1Request(r *http.Request) (friendship.BulkAddFriendsV1Params, error) {
	var params friendship.BulkAddFriendsV1Params
	if err := gojiplus.ParseJSONFromRequest(r, &params); err != nil {
		return friendship.BulkAddFriendsV1Params{}, errx.New(err)
	}

	return params, nil
}
