package api

import (
	"context"

	"code.justin.tv/chat/friendship/rpc/friends"
)

func (s *Server) ClearUnreadCount(
	ctx context.Context,
	req *friends.ClearUnreadCountReq,
) (*friends.ClearUnreadCountResp, error) {

	err := s.backend.ResetNotifications(ctx, req.UserId)
	if err != nil {
		return nil, err
	}

	return &friends.ClearUnreadCountResp{}, nil
}
