package api

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"
	"code.justin.tv/chat/friendship/rpc/friends"
	"code.justin.tv/chat/redis"
)

func TestGetIncomingFriendRequests(t *testing.T) {
	t.Run("should succeed", func(t *testing.T) {
		server, b := serverWithTestBackend(t)
		mockFriends := b.Friends.(*backendtest.CohesionClient)

		req := friends.GetIncomingFriendRequestsReq{
			UserId: backend.AliceID,
		}

		mockRedis := b.Redis.(*redis.MockRedis)
		mockRedis.On("Scard", mock.Anything, "incoming_request:"+backend.AliceID).Return(1, nil).Once()

		resp, err := server.GetIncomingFriendRequests(context.Background(), &req)

		assert.Equal(t, resp.Total, int64(0))
		assert.NoError(t, err)

		assert.Equal(t, 10, len(mockFriends.GetCalls()))

		calls := mockFriends.GetCalls()
		listCall := calls[0]
		expected := backendtest.Call{
			Name:       "CountAssoc",
			E1:         backend.AliceID,
			Kind:       backend.RequestedByUser,
			EntityKind: backend.User,
		}
		validateCall(t, listCall, expected)

		countCall := calls[1]
		expected = backendtest.Call{
			Name:       "CountAssoc",
			E1:         backend.AliceID,
			Kind:       backend.RequestedByStranger,
			EntityKind: backend.User,
		}
		validateCall(t, countCall, expected)
	})
}
