package api

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"
	"code.justin.tv/chat/redis"
)

func TestRejectRequestV0WhileLocked(t *testing.T) {
	s, b := serverWithTestBackend(t)

	mockRedis := b.Redis.(*redis.MockRedis)
	defer mockRedis.AssertExpectations(t)
	mockRedis.On("DistLock", mock.Anything, fmt.Sprintf("all_relationships:%s,%s", backend.BobID, backend.AliceID), mock.Anything).
		Return(false, nil)

	mockFriends := b.Friends.(*backendtest.CohesionClient)
	assert.Equal(t, len(mockFriends.GetCalls()), 0)

	path := fmt.Sprintf("/users/%s/friends/requests/%s", backend.AliceID, backend.BobID)
	w := doTestHTTP(t, s, "DELETE", path)

	assert.Equal(t, w.Result().StatusCode, 409)
}
