package friendship

import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
	"time"

	"golang.org/x/net/context"

	"code.justin.tv/foundation/twitchclient"
)

type BulkAddFriendsV1Params struct {
	TargetIDs []string
}

func (c *clientImpl) BulkAddFriends(ctx context.Context, userID string, targetIDs []string, reqOpts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/users/%s/friends", userID)

	params := BulkAddFriendsV1Params{
		TargetIDs: targetIDs,
	}
	jsonBody, err := json.Marshal(params)
	if err != nil {
		return err
	}

	req, err := c.NewRequest("PUT", path, bytes.NewBuffer(jsonBody))
	if err != nil {
		return fmt.Errorf("can't construct bulk_add_friends request: %s", err)
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.friendship.bulk_add_friends",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, 10*time.Second)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusNoContent {
		return twitchclient.HandleFailedResponse(resp)
	}

	return nil
}
