package friendship

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) RejectRequest(ctx context.Context, userID, requesterID string, reqOpts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/users/%s/friends/%s/requests", userID, requesterID)
	req, err := c.NewRequest("DELETE", path, nil)
	if err != nil {
		return err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.friendship.reject_request",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusNoContent {
		return twitchclient.HandleFailedResponse(resp)
	}

	return nil
}
