// +build integration

package masonry

import (
	"testing"

	"code.justin.tv/feeds/service-common"
	"github.com/aws/aws-sdk-go/service/sqs"
	. "github.com/smartystreets/goconvey/convey"
)

func TestIntegration_QueueClient(t *testing.T) {
	Convey("With a client", t, func() {
		s := service_common.ConfigCommon{
			Team:          "feeds",
			Service:       "int_tests",
			BaseDirectory: "../",
		}
		So(s.Setup(), ShouldBeNil)
		session, awsConf := service_common.CreateAWSSession(s.Config)
		sqsClient := sqs.New(session, awsConf...)
		lqi := sqs.ListQueuesInput{}
		lqOut, err := sqsClient.ListQueues(&lqi)
		So(err, ShouldBeNil)
		So(len(lqOut.QueueUrls), ShouldBeGreaterThan, 0)
	})
}
