// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: proto/graphdb.proto

/*
Package graphdb is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	proto/graphdb.proto
*/
package graphdb

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// =================
// GraphDB Interface
// =================

// GraphDB allows creation of nodes and edges inside a generic graph database
type GraphDB interface {
	// EdgeGet returns an association between two entities.  Returns nil if no assoc exists
	EdgeGet(context.Context, *EdgeGetRequest) (*EdgeGetResponse, error)

	// EdgeCreate creates an association only if one does not exist.  If one did exist, returns nil.
	EdgeCreate(context.Context, *EdgeCreateRequest) (*EdgeCreateResponse, error)

	// EdgeUpdate updates the values of an association only if does exist.  Returns the new value.
	// If one did not exist, returns nil.
	EdgeUpdate(context.Context, *EdgeUpdateRequest) (*EdgeUpdateResponse, error)

	// EdgeCount counts the assocs from a source.
	EdgeCount(context.Context, *EdgeCountRequest) (*EdgeCountResponse, error)

	// EdgeUpdateType changes the type of an assoc
	EdgeUpdateType(context.Context, *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error)

	// EdgeDelete removes an association between two entities.  Returns the removed entity, or nil if one did not exist.
	EdgeDelete(context.Context, *EdgeDeleteRequest) (*EdgeDeleteResponse, error)

	// EdgeList lists the assocs from an entity.
	// May consume one read unit, may consume more
	EdgeList(context.Context, *EdgeListRequest) (*EdgeListResponse, error)

	// NodeGet returns a node in the graph
	NodeGet(context.Context, *NodeGetRequest) (*NodeGetResponse, error)

	// NodeCreate creates a node in the graph
	NodeCreate(context.Context, *NodeCreateRequest) (*NodeCreateResponse, error)

	// NodeUpdate modifies a node that already exists in the graph
	NodeUpdate(context.Context, *NodeUpdateRequest) (*NodeUpdateResponse, error)

	// NodeCount counts the types of a node
	NodeCount(context.Context, *NodeCountRequest) (*NodeCountResponse, error)

	// NodeDelete removes a node in the graph.  It will not remove any edges out of the node.
	NodeDelete(context.Context, *NodeDeleteRequest) (*NodeDeleteResponse, error)

	// NodeList lists all the nodes of a type
	NodeList(context.Context, *NodeListRequest) (*NodeListResponse, error)

	// Multi is a way to batch serial requests into a single operation for cohesion.  It won't be more efficient
	// for DynamoDB, but can save trips to graphdb.
	Multi(context.Context, *MultiRequest) (*MultiResponse, error)

	// MultiAsync sends multiple update requests to execute eventually with a SQS queue.  It is useful for only
	// modification reqeusts, since you can't see the result.
	MultiAsync(context.Context, *MultiAsyncRequest) (*MultiAsyncResponse, error)
}

// =======================
// GraphDB Protobuf Client
// =======================

type graphDBProtobufClient struct {
	client HTTPClient
	urls   [15]string
}

// NewGraphDBProtobufClient creates a Protobuf client that implements the GraphDB interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewGraphDBProtobufClient(addr string, client HTTPClient) GraphDB {
	prefix := urlBase(addr) + GraphDBPathPrefix
	urls := [15]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeUpdateType",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "NodeGet",
		prefix + "NodeCreate",
		prefix + "NodeUpdate",
		prefix + "NodeCount",
		prefix + "NodeDelete",
		prefix + "NodeList",
		prefix + "Multi",
		prefix + "MultiAsync",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &graphDBProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &graphDBProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *graphDBProtobufClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeUpdateType(ctx context.Context, in *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	out := new(EdgeUpdateTypeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *graphDBProtobufClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeGet(ctx context.Context, in *NodeGetRequest) (*NodeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	out := new(NodeGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeCreate(ctx context.Context, in *NodeCreateRequest) (*NodeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	out := new(NodeCreateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeUpdate(ctx context.Context, in *NodeUpdateRequest) (*NodeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	out := new(NodeUpdateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeCount(ctx context.Context, in *NodeCountRequest) (*NodeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	out := new(NodeCountResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeDelete(ctx context.Context, in *NodeDeleteRequest) (*NodeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	out := new(NodeDeleteResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *graphDBProtobufClient) NodeList(ctx context.Context, in *NodeListRequest) (*NodeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(NodeListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *graphDBProtobufClient) Multi(ctx context.Context, in *MultiRequest) (*MultiResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	out := new(MultiResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *graphDBProtobufClient) MultiAsync(ctx context.Context, in *MultiAsyncRequest) (*MultiAsyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	out := new(MultiAsyncResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

// ===================
// GraphDB JSON Client
// ===================

type graphDBJSONClient struct {
	client HTTPClient
	urls   [15]string
}

// NewGraphDBJSONClient creates a JSON client that implements the GraphDB interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewGraphDBJSONClient(addr string, client HTTPClient) GraphDB {
	prefix := urlBase(addr) + GraphDBPathPrefix
	urls := [15]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeUpdateType",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "NodeGet",
		prefix + "NodeCreate",
		prefix + "NodeUpdate",
		prefix + "NodeCount",
		prefix + "NodeDelete",
		prefix + "NodeList",
		prefix + "Multi",
		prefix + "MultiAsync",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &graphDBJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &graphDBJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *graphDBJSONClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeUpdateType(ctx context.Context, in *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	out := new(EdgeUpdateTypeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *graphDBJSONClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeGet(ctx context.Context, in *NodeGetRequest) (*NodeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	out := new(NodeGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeCreate(ctx context.Context, in *NodeCreateRequest) (*NodeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	out := new(NodeCreateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeUpdate(ctx context.Context, in *NodeUpdateRequest) (*NodeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	out := new(NodeUpdateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeCount(ctx context.Context, in *NodeCountRequest) (*NodeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	out := new(NodeCountResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeDelete(ctx context.Context, in *NodeDeleteRequest) (*NodeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	out := new(NodeDeleteResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *graphDBJSONClient) NodeList(ctx context.Context, in *NodeListRequest) (*NodeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(NodeListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *graphDBJSONClient) Multi(ctx context.Context, in *MultiRequest) (*MultiResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	out := new(MultiResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *graphDBJSONClient) MultiAsync(ctx context.Context, in *MultiAsyncRequest) (*MultiAsyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	out := new(MultiAsyncResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

// ======================
// GraphDB Server Handler
// ======================

type graphDBServer struct {
	GraphDB
	hooks *twirp.ServerHooks
}

func NewGraphDBServer(svc GraphDB, hooks *twirp.ServerHooks) TwirpServer {
	return &graphDBServer{
		GraphDB: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *graphDBServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// GraphDBPathPrefix is used for all URL paths on a twirp GraphDB server.
// Requests are always: POST GraphDBPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GraphDBPathPrefix = "/twirp/graphdb.GraphDB/"

func (s *graphDBServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/graphdb.GraphDB/EdgeGet":
		s.serveEdgeGet(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeCreate":
		s.serveEdgeCreate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeUpdate":
		s.serveEdgeUpdate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeCount":
		s.serveEdgeCount(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeUpdateType":
		s.serveEdgeUpdateType(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeDelete":
		s.serveEdgeDelete(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeList":
		s.serveEdgeList(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeGet":
		s.serveNodeGet(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeCreate":
		s.serveNodeCreate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeUpdate":
		s.serveNodeUpdate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeCount":
		s.serveNodeCount(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeDelete":
		s.serveNodeDelete(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeList":
		s.serveNodeList(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/Multi":
		s.serveMulti(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/MultiAsync":
		s.serveMultiAsync(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *graphDBServer) serveEdgeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCreateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeCreateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeUpdateTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateTypeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateTypeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeUpdateType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateTypeResponse and nil error while calling EdgeUpdateType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeUpdateTypeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateTypeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeUpdateType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateTypeResponse and nil error while calling EdgeUpdateType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeGetResponse and nil error while calling NodeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeGetResponse and nil error while calling NodeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeCreateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCreateResponse and nil error while calling NodeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeCreateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCreateResponse and nil error while calling NodeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeUpdateResponse and nil error while calling NodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeUpdateResponse and nil error while calling NodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCountResponse and nil error while calling NodeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCountResponse and nil error while calling NodeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeDeleteResponse and nil error while calling NodeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeDeleteResponse and nil error while calling NodeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeListResponse and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeListResponse and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMulti(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMultiJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMultiProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveMultiJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MultiRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Multi(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiResponse and nil error while calling Multi. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(MultiRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Multi(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiResponse and nil error while calling Multi. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiAsync(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMultiAsyncJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMultiAsyncProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveMultiAsyncJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MultiAsyncRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiAsyncResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.MultiAsync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiAsyncResponse and nil error while calling MultiAsync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiAsyncProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(MultiAsyncRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiAsyncResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.MultiAsync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiAsyncResponse and nil error while calling MultiAsync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *graphDBServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1596 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xdf, 0x8e, 0xdb, 0x44,
	0x17, 0x4f, 0x6c, 0xa7, 0x49, 0x4e, 0x77, 0xd3, 0x74, 0xba, 0xed, 0x97, 0x7a, 0xd5, 0xaf, 0xad,
	0xa1, 0xb0, 0xad, 0x50, 0x56, 0xb4, 0xd0, 0x2e, 0x8b, 0xba, 0x28, 0xbb, 0xa9, 0x5a, 0x4a, 0x0b,
	0xc8, 0xdb, 0x5e, 0x80, 0x40, 0x91, 0x77, 0x3d, 0x4d, 0x0d, 0x59, 0x3b, 0xd8, 0x93, 0xad, 0x22,
	0x71, 0x07, 0x77, 0x3c, 0x00, 0xaf, 0x00, 0x42, 0xe2, 0x09, 0x10, 0xf7, 0x5c, 0x73, 0xc5, 0xdb,
	0xa0, 0xf9, 0x63, 0x7b, 0xec, 0x71, 0x62, 0xb7, 0x5d, 0x71, 0xe7, 0x99, 0x39, 0xbf, 0x33, 0x73,
	0xce, 0xf9, 0xcd, 0x99, 0x33, 0x63, 0x38, 0x37, 0x0d, 0x03, 0x12, 0x6c, 0x8e, 0x43, 0x67, 0xfa,
	0xdc, 0x3d, 0xe8, 0xb3, 0x16, 0x6a, 0x8a, 0xa6, 0x79, 0x79, 0x1c, 0x04, 0xe3, 0x09, 0xde, 0x64,
	0xdd, 0x07, 0xb3, 0x67, 0x9b, 0xc4, 0x3b, 0xc2, 0x11, 0x71, 0x8e, 0xa6, 0x5c, 0xd2, 0xfa, 0x5d,
	0x87, 0xb3, 0x8f, 0x67, 0x13, 0xe2, 0x0d, 0xa2, 0xb9, 0x7f, 0x68, 0xe3, 0xef, 0x66, 0x38, 0x22,
	0x68, 0x08, 0xad, 0x90, 0x7f, 0x46, 0xbd, 0xfa, 0x15, 0x7d, 0xe3, 0xf4, 0xcd, 0x8d, 0x7e, 0x3c,
	0x83, 0x22, 0xdd, 0xdf, 0xf7, 0xfc, 0xf1, 0x04, 0x8b, 0x96, 0x9d, 0x20, 0xd1, 0x06, 0x74, 0xa7,
	0x61, 0x70, 0x88, 0xa3, 0x68, 0xe4, 0xe2, 0x89, 0x33, 0x1f, 0x1d, 0x45, 0x3d, 0xed, 0x4a, 0x7d,
	0x43, 0xb7, 0x3b, 0xa2, 0x7f, 0x48, 0xbb, 0x1f, 0x47, 0xe6, 0x2f, 0x1a, 0xac, 0x66, 0xb4, 0xa0,
	0xbb, 0x70, 0x1a, 0xbb, 0x63, 0x3c, 0x3a, 0x0c, 0xb1, 0x43, 0x70, 0xaf, 0x7e, 0xa5, 0xbe, 0x71,
	0xfa, 0xa6, 0x99, 0x2c, 0xe2, 0x9e, 0x3b, 0xc6, 0x7b, 0x6c, 0x48, 0x00, 0x1e, 0xd4, 0x6c, 0xc0,
	0x49, 0x67, 0x02, 0x9f, 0x4d, 0x5d, 0x0a, 0xd7, 0x0a, 0xe0, 0x4f, 0xd9, 0x50, 0x0e, 0xce, 0x3b,
	0x13, 0xb8, 0x8b, 0x27, 0x98, 0xe0, 0x9e, 0x5e, 0x00, 0x1f, 0xb2, 0xa1, 0x1c, 0x9c, 0x77, 0xa2,
	0x87, 0xd0, 0xe5, 0x8b, 0x7f, 0xee, 0xf8, 0x63, 0x3c, 0x22, 0xf3, 0x29, 0xee, 0x19, 0x4c, 0xc7,
	0xff, 0x0b, 0x96, 0xf0, 0x64, 0x3e, 0x95, 0xf4, 0x74, 0x98, 0x15, 0x0c, 0x48, 0x07, 0x76, 0x3b,
	0xb0, 0x22, 0x1c, 0xca, 0xf4, 0x58, 0x6b, 0x80, 0xe4, 0x08, 0x44, 0xd3, 0xc0, 0x8f, 0xb0, 0xf5,
	0x9b, 0x01, 0x2b, 0xac, 0x3b, 0xf6, 0xdf, 0x47, 0x4a, 0x04, 0xdf, 0xc8, 0x46, 0xb0, 0x24, 0x78,
	0xe6, 0xdf, 0x7a, 0x3e, 0x24, 0xef, 0x41, 0x8b, 0x59, 0x35, 0xc6, 0x44, 0xc4, 0xe3, 0x7f, 0x19,
	0x6b, 0xee, 0x63, 0x92, 0x9a, 0xd1, 0xc4, 0xbc, 0x27, 0x1f, 0x48, 0xed, 0xf5, 0x02, 0xa9, 0xbf,
	0x64, 0x20, 0xb7, 0x01, 0xf8, 0xec, 0xc1, 0xcc, 0x27, 0x22, 0x06, 0x17, 0xb3, 0x93, 0xd3, 0x91,
	0x14, 0xdc, 0xc6, 0x71, 0x5f, 0x9e, 0x04, 0x8d, 0x13, 0x20, 0xc1, 0xa9, 0x57, 0x23, 0x01, 0xba,
	0x03, 0x6c, 0x5d, 0xa3, 0x89, 0x17, 0x91, 0x5e, 0x93, 0x29, 0xe9, 0x65, 0x94, 0x3c, 0xf2, 0x22,
	0xc9, 0x08, 0x16, 0x27, 0xda, 0x95, 0x67, 0xcf, 0x43, 0xa3, 0xa5, 0x75, 0x75, 0xeb, 0x1f, 0x03,
	0x56, 0x05, 0x09, 0x38, 0x7f, 0xd0, 0x80, 0xd2, 0x85, 0x7f, 0x0b, 0xba, 0x5c, 0xcb, 0xd3, 0x85,
	0x8f, 0x26, 0x7c, 0xe1, 0x4d, 0x3b, 0x81, 0x99, 0x3f, 0x1a, 0xd0, 0xc9, 0x0e, 0xa2, 0xf7, 0x15,
	0xc6, 0xf4, 0x54, 0xc6, 0x70, 0x59, 0x99, 0x32, 0x3b, 0x45, 0x94, 0x59, 0x2f, 0xa4, 0x4c, 0x02,
	0x96, 0x39, 0xb3, 0x53, 0xc4, 0x99, 0xf5, 0x42, 0xce, 0x64, 0xf1, 0x82, 0x34, 0x1f, 0x16, 0x90,
	0xc6, 0x2c, 0x22, 0x4d, 0x82, 0x96, 0x58, 0xb3, 0x53, 0xc4, 0x9a, 0xf5, 0x42, 0xd6, 0x64, 0x27,
	0x17, 0xb4, 0xf9, 0x64, 0x21, 0x6d, 0x2e, 0x2f, 0xa4, 0x4d, 0xa2, 0x28, 0xcf, 0x9b, 0x2d, 0x95,
	0x37, 0x17, 0x0b, 0x78, 0x93, 0xe0, 0x13, 0xe2, 0xa0, 0xb7, 0xa0, 0x81, 0xc3, 0x30, 0x08, 0x7b,
	0x6b, 0x0c, 0xd5, 0x49, 0x51, 0xb4, 0xf7, 0x41, 0xcd, 0xe6, 0xc3, 0xbb, 0x67, 0x60, 0x35, 0x66,
	0x00, 0xcf, 0x4f, 0x57, 0xa1, 0xc1, 0x44, 0x50, 0x0f, 0x9a, 0x47, 0x38, 0x8a, 0x9c, 0x31, 0xcf,
	0xde, 0x6d, 0x3b, 0x6e, 0x5a, 0x4f, 0xe1, 0x7c, 0x21, 0xf1, 0xd1, 0x55, 0x30, 0xe8, 0x02, 0x04,
	0x57, 0x56, 0x33, 0x2b, 0xb5, 0xd9, 0x10, 0xba, 0x08, 0x2d, 0x1f, 0xbf, 0xe0, 0x6e, 0xd1, 0xb8,
	0x5a, 0x1f, 0xbf, 0xa0, 0x4a, 0xac, 0x01, 0x5c, 0x28, 0x76, 0x0c, 0x7a, 0x3b, 0xa3, 0xf7, 0x5c,
	0xa2, 0xf7, 0x51, 0xe0, 0xb8, 0xd8, 0x4d, 0xb5, 0x5b, 0xb7, 0xe1, 0xac, 0xb2, 0xad, 0x2b, 0xac,
	0xca, 0xba, 0x0b, 0x48, 0x0d, 0x6c, 0xf5, 0x69, 0xbf, 0x87, 0x33, 0xb9, 0x4d, 0x4c, 0x27, 0x7d,
	0x16, 0x06, 0x47, 0xca, 0xa4, 0x9f, 0x06, 0x2e, 0xb6, 0xd9, 0x10, 0x5a, 0x17, 0xc1, 0x95, 0x7c,
	0xc1, 0xe2, 0xc7, 0x22, 0x7f, 0x1d, 0x8c, 0x29, 0x75, 0x3d, 0x27, 0xff, 0xf9, 0x04, 0xff, 0xb9,
	0x33, 0xc6, 0x6e, 0x9c, 0xed, 0x99, 0x88, 0x75, 0x08, 0xdd, 0x3c, 0x15, 0xd0, 0x05, 0x38, 0x75,
	0x38, 0x0b, 0xa3, 0x20, 0x14, 0xb1, 0x13, 0x2d, 0xf4, 0x2e, 0x34, 0xe8, 0x14, 0x51, 0x4f, 0x67,
	0x49, 0x62, 0x3d, 0x67, 0xd3, 0x1e, 0x93, 0x12, 0xb6, 0x71, 0x49, 0x91, 0x72, 0x6c, 0x3e, 0x89,
	0x9c, 0x6d, 0x5f, 0xd7, 0x46, 0xeb, 0x3a, 0x8f, 0x56, 0x66, 0x33, 0xa2, 0x35, 0x68, 0xf0, 0x7d,
	0x5b, 0x67, 0x95, 0x06, 0x6f, 0x58, 0x7f, 0xd6, 0xb9, 0x6c, 0xe6, 0xac, 0xa8, 0xc2, 0xb7, 0x37,
	0xc1, 0x70, 0x1d, 0xe2, 0x88, 0x24, 0xd4, 0x4d, 0x44, 0x86, 0x0e, 0x71, 0x76, 0x9d, 0xb1, 0xcd,
	0x46, 0xd1, 0x35, 0xe8, 0x04, 0xc7, 0x38, 0x7c, 0x11, 0x7a, 0x04, 0x8f, 0x98, 0x3c, 0xf5, 0x7b,
	0xcb, 0x5e, 0x4d, 0x7a, 0xa9, 0x3c, 0xfa, 0x00, 0x80, 0xe7, 0x34, 0x77, 0xe4, 0x48, 0x89, 0x85,
	0x95, 0x68, 0xfd, 0xb8, 0x44, 0xeb, 0x3f, 0x89, 0x4b, 0x34, 0xbb, 0x2d, 0xa4, 0x07, 0x24, 0x66,
	0x58, 0x36, 0x6f, 0x55, 0x67, 0xd8, 0xcf, 0xc2, 0xfe, 0xcc, 0x51, 0x7b, 0x72, 0xf6, 0x67, 0x0d,
	0xd3, 0x5f, 0xc1, 0xb0, 0x6c, 0x42, 0xaf, 0x6e, 0xd8, 0x2d, 0xe8, 0x64, 0x6b, 0x8f, 0x2a, 0xdb,
	0x75, 0x9b, 0xef, 0x37, 0xe9, 0xf8, 0xa9, 0x3e, 0xe1, 0x0d, 0x30, 0x28, 0x3f, 0x11, 0x02, 0x83,
	0x91, 0x92, 0xef, 0x0f, 0xf6, 0x8d, 0x3a, 0xa0, 0x79, 0xae, 0xa0, 0xa9, 0xe6, 0xb9, 0x96, 0x0d,
	0xc0, 0xf1, 0x0c, 0x71, 0x15, 0x0c, 0x3f, 0x70, 0xf1, 0x02, 0xba, 0xfb, 0x42, 0x44, 0xf2, 0xf6,
	0x6a, 0xc6, 0xdb, 0xdc, 0xd5, 0xd6, 0x57, 0x60, 0xd0, 0xd5, 0x54, 0xd9, 0x3c, 0x97, 0x40, 0x23,
	0x81, 0xa2, 0x8b, 0x09, 0x68, 0x24, 0x48, 0x2c, 0xd0, 0x53, 0x0b, 0xd2, 0x15, 0xc7, 0x73, 0x94,
	0xf1, 0x23, 0x5e, 0xb1, 0xb1, 0x78, 0xc5, 0xb7, 0xa0, 0x43, 0xe7, 0xcc, 0x86, 0xa8, 0xc4, 0x13,
	0x34, 0x44, 0x09, 0x28, 0x0d, 0x91, 0x84, 0xca, 0x87, 0x48, 0xc2, 0x52, 0xb2, 0xd3, 0xa6, 0x42,
	0xf6, 0x32, 0xf7, 0xff, 0x17, 0x64, 0x97, 0x17, 0xf6, 0xb2, 0x86, 0xfd, 0x20, 0x0c, 0x53, 0xb2,
	0xd8, 0xc9, 0x18, 0x56, 0x2d, 0x8b, 0xc5, 0x46, 0xa8, 0xa9, 0xa8, 0x9a, 0x11, 0x9b, 0xd0, 0x65,
	0x3e, 0x90, 0x4f, 0x82, 0x75, 0x68, 0xd3, 0xb1, 0x91, 0xb4, 0xa3, 0x5a, 0xb4, 0x23, 0x4e, 0xf3,
	0x12, 0x60, 0x69, 0x9a, 0xbf, 0xcd, 0x45, 0x95, 0xf3, 0xbb, 0x8c, 0x6d, 0xc2, 0x24, 0xf5, 0xfc,
	0xae, 0x66, 0xd2, 0x4f, 0x75, 0x58, 0x91, 0x0f, 0xd6, 0x85, 0xc7, 0xe7, 0x1a, 0x34, 0x26, 0xde,
	0x91, 0x47, 0xc4, 0x35, 0x98, 0x37, 0xe8, 0xa1, 0x1a, 0x84, 0x2e, 0x0e, 0x99, 0xbb, 0x3b, 0xd2,
	0xa1, 0x2a, 0xeb, 0xec, 0x7f, 0x46, 0x45, 0x6c, 0x2e, 0x69, 0x99, 0xd0, 0x60, 0x6d, 0xd4, 0x04,
	0x7d, 0xb0, 0xbf, 0xd7, 0xad, 0xa1, 0x16, 0x18, 0xc3, 0x7b, 0xfb, 0x7b, 0xdd, 0xba, 0xf5, 0x05,
	0xdf, 0x3a, 0x72, 0x35, 0xb1, 0xcc, 0xbf, 0x49, 0xa9, 0xa0, 0x95, 0x97, 0x0a, 0x5f, 0xf3, 0xd8,
	0x55, 0x2d, 0x15, 0xe8, 0x14, 0xf4, 0xca, 0xbf, 0xac, 0x54, 0x60, 0x6e, 0xe4, 0x92, 0xd6, 0x53,
	0x40, 0xea, 0x60, 0xe5, 0x30, 0x48, 0x2b, 0xd1, 0xe4, 0x95, 0xa8, 0x6a, 0x59, 0x72, 0xab, 0x9a,
	0xf1, 0x17, 0xaa, 0xfd, 0xa3, 0x0e, 0x46, 0xc1, 0xb1, 0x5e, 0x7f, 0x89, 0x84, 0x40, 0xa1, 0xfc,
	0x96, 0xc2, 0xa0, 0x5a, 0x39, 0x54, 0x48, 0x0f, 0x08, 0xad, 0xaf, 0x8f, 0x71, 0x18, 0x79, 0x81,
	0xcf, 0x78, 0xa3, 0xdb, 0x71, 0x33, 0xd9, 0xed, 0xc6, 0xb2, 0xdd, 0x6e, 0xfd, 0xa5, 0x43, 0x53,
	0xf4, 0xa0, 0x3e, 0x18, 0x9e, 0x9f, 0xbc, 0x14, 0x98, 0x79, 0x44, 0xff, 0x63, 0x9f, 0x44, 0xf7,
	0x7c, 0x12, 0xce, 0x6d, 0x26, 0x47, 0x63, 0x7b, 0x10, 0x04, 0x13, 0x35, 0xb6, 0x31, 0x60, 0x97,
	0x8e, 0x72, 0x04, 0x97, 0x44, 0x77, 0xa0, 0x19, 0x91, 0xd0, 0xf3, 0xc7, 0x71, 0xed, 0x78, 0x49,
	0x01, 0xed, 0xf3, 0x71, 0x0e, 0x8b, 0xa5, 0x29, 0xd0, 0x0d, 0x66, 0x07, 0x13, 0x1c, 0xf5, 0x8c,
	0x05, 0xc0, 0x21, 0x1f, 0x17, 0x40, 0x21, 0x6d, 0xde, 0x81, 0x76, 0xb2, 0x6e, 0xd4, 0x05, 0xfd,
	0x5b, 0x3c, 0x17, 0x14, 0xa5, 0x9f, 0x74, 0x2f, 0x1e, 0x3b, 0x93, 0x19, 0x8e, 0xf7, 0x22, 0x6b,
	0x6c, 0x6b, 0x5b, 0x75, 0x73, 0x0b, 0x20, 0x5d, 0x7f, 0x19, 0xb2, 0x25, 0x23, 0xb7, 0x61, 0x45,
	0x36, 0xa2, 0x0c, 0xdb, 0xce, 0x61, 0x65, 0x3b, 0xca, 0xb0, 0x75, 0x09, 0x7b, 0xf3, 0xd7, 0x16,
	0x34, 0xef, 0x53, 0xa7, 0x0c, 0x77, 0xd1, 0x0e, 0x34, 0x45, 0x71, 0x83, 0x16, 0xbd, 0xcf, 0x98,
	0x0b, 0xaf, 0xe1, 0x56, 0x0d, 0xdd, 0x07, 0x48, 0x0b, 0x32, 0xb4, 0xe4, 0xa5, 0xc6, 0x5c, 0x76,
	0x25, 0x4f, 0x15, 0x89, 0x4b, 0xf5, 0x92, 0x37, 0x1b, 0x73, 0xd9, 0xdd, 0xdc, 0xaa, 0xa1, 0x21,
	0xb4, 0x93, 0x3a, 0x1f, 0x2d, 0x7e, 0xbd, 0x31, 0x97, 0xdc, 0xd1, 0xad, 0x1a, 0xda, 0xe7, 0x95,
	0x62, 0x7a, 0x3d, 0x44, 0x25, 0xef, 0x30, 0x66, 0xd9, 0x85, 0x3b, 0xb5, 0x51, 0xdc, 0xdd, 0x97,
	0x3c, 0x0e, 0x99, 0xcb, 0x9e, 0x00, 0xac, 0x1a, 0x1a, 0x40, 0x2b, 0xbe, 0x84, 0xa1, 0x85, 0x4f,
	0x3b, 0xe6, 0xe2, 0xcb, 0xbb, 0x55, 0xa3, 0x81, 0x17, 0x25, 0x93, 0x14, 0xf8, 0x6c, 0xe5, 0x25,
	0x05, 0x3e, 0x57, 0x5d, 0x71, 0x5b, 0xd2, 0xe2, 0x44, 0xb2, 0x45, 0x29, 0xa5, 0x24, 0x5b, 0xd4,
	0x6a, 0x26, 0x55, 0xa4, 0x04, 0x5e, 0x29, 0x5d, 0x72, 0x8a, 0x8a, 0x02, 0x9f, 0x9c, 0xfc, 0x52,
	0xe0, 0xf3, 0xe5, 0x83, 0x69, 0x16, 0x0d, 0xe5, 0x97, 0xa3, 0xc4, 0x48, 0xa9, 0x14, 0x72, 0xcb,
	0x29, 0x8a, 0x51, 0x7c, 0xfa, 0xa1, 0xac, 0x23, 0x8b, 0x63, 0x94, 0x3f, 0x2a, 0xad, 0x1a, 0xda,
	0x82, 0x06, 0x7b, 0x4e, 0x43, 0xe7, 0x0b, 0x5f, 0x63, 0xcd, 0x0b, 0xc5, 0xaf, 0x6e, 0xdc, 0x8a,
	0xf4, 0xdd, 0x57, 0xb2, 0x42, 0x79, 0x8e, 0x97, 0xac, 0x28, 0x78, 0x28, 0xae, 0xed, 0xbe, 0xf3,
	0xe5, 0x8d, 0xc3, 0xc0, 0xc5, 0xfd, 0x6f, 0x66, 0x11, 0xf1, 0xfc, 0x3e, 0x39, 0xde, 0x7c, 0x86,
	0xb1, 0x1b, 0xc5, 0x7f, 0x10, 0x36, 0x33, 0xff, 0x13, 0x0e, 0x4e, 0xb1, 0xe6, 0xad, 0x7f, 0x03,
	0x00, 0x00, 0xff, 0xff, 0x5c, 0x0b, 0xc0, 0x4c, 0x67, 0x18, 0x00, 0x00,
}
