# sandyconf

A way to talk to sandstorm from within your application as a configuration variable.

# Example usage

Sandyconf forces configuration variables into a hierarchy of Team, Service, Environment.  Because creating a sandstorm
manager struct is somewhat complicated, a manager constructor object is provided.  However, you will need to pass
in the ARN used by sandstorm to fetch configuration values.  A typical usage is like below.  The below example fetches
a sandstorm value at "feeds/audrey/development/fanout.sql_password".

If keeping secrets separate from configuration is important, it may be useful to have two distconf managers: one for
secrets and one for configuration.

```
    roleARN := "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/audrey-development"
    mc := ManagerConstructor{}
    mgr := mc.Manager(roleARN)
    s := &Sandyconf {
        Team:        "feeds",
        Service:     "audrey",
        Environment: "development",
        Manager:     mgr,
    }
    
    
    secretDconf := distconf.Distconf {
        Readers: []distconf.Reader {
            s,
        }
    }
    dbPasswordConf := secretDconf.Str("fanout.sql_password", "")
```