package httpheaders

import "net/http"

// HeaderRoundTripper is a http round tripper that adds headers to requests
type HeaderRoundTripper struct {
	RoundTripper http.RoundTripper
	HeaderName   string
	HeaderValue  string
}

var _ http.RoundTripper = &HeaderRoundTripper{}

// RoundTrip adds header name to the req
func (h *HeaderRoundTripper) RoundTrip(req *http.Request) (*http.Response, error) {
	roundTripper := h.RoundTripper
	if roundTripper == nil {
		roundTripper = http.DefaultTransport
	}
	return setupHeaders(req, h.HeaderName, h.HeaderValue, roundTripper.RoundTrip)
}

// WithHeaderRoundTripper creates a HeaderRoundTripper with  http.DefaultTransport as the default roundTripper
func WithHeaderRoundTripper(roundTripper http.RoundTripper, headerName string, headerValue string) *HeaderRoundTripper {
	return &HeaderRoundTripper{
		RoundTripper: roundTripper,
		HeaderName:   headerName,
		HeaderValue:  headerValue,
	}
}
