package associations

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func init() {
	InitTestSchema()
}

func TestEntityKindFromString(t *testing.T) {
	Convey("Should return correct entity kind for valid string", t, func() {
		val, ok := SchemaManager.EntityKind("user")
		So(ok, ShouldBeTrue)
		So(val, ShouldResemble, UserKind)
	})

	Convey("Should return an invalid result otherwise", t, func() {
		_, ok := SchemaManager.EntityKind("jos")
		So(ok, ShouldBeFalse)
	})
}

func TestValidate(t *testing.T) {
	Convey("should validate kind", t, func() {
		e := Entity{ID: "123", Kind: SchemaManager.UnknownEntityKind}

		err := e.Validate()

		So(err, ShouldNotBeNil)
		So(err.Error(), ShouldContainSubstring, "Invalid entity kind")
	})

	Convey("should validate EmptyEntity", t, func() {
		e := SchemaManager.EmptyEntity

		err := e.Validate()

		So(err, ShouldBeNil)
	})
}
