package v2

import (
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
)

func (c *v2Client) Associations(ctx context.Context, from Entity, to Entity) (*ListAssocResponseWithMeta, error) {
	request, err := c.newRequest(from, "", to, nil)
	if err != nil {
		return nil, err
	}

	resp, err := c.conn.Associations(ctx, request)
	if err != nil {
		if grpc.Code(err) == codes.NotFound {
			return nil, nil
		}
		return nil, err
	}

	return newListAssocResponseWithMeta(resp), err
}

func (c *v2Client) BatchAssociations(ctx context.Context, from Entity, toKind string, toIDs []string) (*ListAssocResponseWithMeta, error) {
	request, err := c.newBatchGetRequest(from, "unknown", toKind, toIDs)
	if err != nil {
		return nil, err
	}

	resp, err := c.conn.Associations(ctx, request)
	if err != nil {
		if grpc.Code(err) == codes.NotFound {
			return nil, nil
		}
		return nil, err
	}

	return newListAssocResponseWithMeta(resp), err
}
