package v2

import (
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
)

// Create sends a request to create an association. The response is always
// empty, so it is omitted in the code and if there is an error that means the
// request failed.
func (c *v2Client) Create(ctx context.Context, from Entity, kind string, to Entity, data map[string]interface{}) error {
	request, err := c.newRequest(from, kind, to, data)
	if err != nil {
		return err
	}

	_, err = c.conn.Create(ctx, request)
	if err != nil && grpc.Code(err) == codes.AlreadyExists {
		err = associations.ErrAssociationExists{}
	}

	return err
}
