package v2

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestEmpty(t *testing.T) {
	Convey("When checking if an Entity is empty", t, func() {
		Convey("It should return true on a new empty Entity", func() {
			e := Entity{}

			So(e.Empty(), ShouldEqual, true)
		})

		Convey("It should return false on a non empty Entity", func() {
			e := Entity{ID: "123"}

			So(e.Empty(), ShouldEqual, false)
		})
	})
}
