# gRPC

## Generating RPC code
Cohesion uses [Retool][1] to ensure all contributors use the same version of `github.com/golang/protobuf`. Because of
this, generating code on any machine should behave the same.

If you don't have Retool, you can get it with
```sh
go get github.com/twitchtv/retool
retool build
```
then use it to generate RPC code with
```sh
retool do go generate
```
from within the `rpc/` directory.

[1]: https://github.com/twitchtv/retool

### Code generation bug
There's currently an undiagnosed bug with Cohesion's code generation that will cause an import to be generated as
```
"code.justin.tv/web/cohesion/vendor/code.justin.tv/common/chitin/grpctrace"
```
rather than
```
"code.justin.tv/common/chitin/grpctrace"
```
in `rpc/api.pb.go`. Switch the line out after generating until this bug is solved.

## Installing protobuf
[Protocol Buffers v3-beta Releases](https://github.com/google/protobuf/releases)

[Protocol Buffers v2 Releases](https://developers.google.com/protocol-buffers/docs/downloads)

[Protocol Buffers Installation Instructions](https://github.com/google/protobuf)

**Note:** If using Mac, you can also install `protobuf` via brew

Installing protobuf also installs the command `protoc` which is used to generate
the `*.pb.go` files from `*.proto`.

## Installing eg
[Package Doc](https://godoc.org/golang.org/x/tools/refactor/eg)

To install the command, run
```sh
go get golang.org/x/tools/cmd/eg
```

For documentation, run
```sh
eg --help
```
